/******************** (C) COPYRIGHT 2007 STMicroelectronics *************************************************************************************************
* File Name          : nand_io.h
* Author             : IMS Systems Lab
* Date First Issued  : 02/8/2007 :  V1.0
* Description        : Description of the nand_io.h file of source code for Communication between small page NAND and ST72F65 Using IO. 
************************************************************************************************************************************************************/
/* History:
* Date          Version     Description
* 02/8/2007 :  V1.0        First issue of firmware
/************************************************************************************************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
************************************************************************************************************************************************************/
/**************************************************************MACRO Definition******************************************************************************/
#define nand_area_A            0x00
#define nand_area_B            0x01
#define nand_area_C            0x50
#define nand_readstatusreg     0x70
#define nand_pageprogram       0x80
#define nand_endpageprogram    0x10
#define nand_read_electsign    0x90
#define nand_blockerase        0x60
#define nand_confirmerase      0xD0
#define nand_reset             0xFF
        
/*************************************************************function decleration**************************************************************************/
void nand_io_init(void);
void command (unsigned char);
void address (unsigned char,unsigned char,unsigned int);
void nand_write(unsigned char*,unsigned char,unsigned char,unsigned int,unsigned char);
void nand_read(unsigned char,unsigned char,unsigned int);
void signature (void);
unsigned char statusreg_read(void);
void block_erase(unsigned int);
void bad_block_decleration(unsigned int);
void readpulses(void);
void writepulses(void);
void writeprotect_enable(void);
void writeprotect_disable(void);
BOOL User_Timeout_Function2(void);


/*****************************************************************end if nand_io.h file******************************************************************/